#ifndef CE2_ECPKI_ECDSA_H
#define CE2_ECPKI_ECDSA_H
/*
 *  Object name     :  CE2__ECPKI_ECDSA.h
   *  State           :  %state%
   *  Creation date   :  02.02.2006
   *  Last modified   :  %modify_time%
   */
/** @file
 * \brief Defines the APIs that support the ECDSA functions. 
 *
 * \version CE2__ECPKI_ECDSA.h#1:hinc:1
 * \author R.Levin
 * \remarks Copyright (C) 2006 by Discretix Technologies Ltd. All rights reserved.
 */

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

 


/**
****************************************************************
* Function Name: 
*  CE2_DX_ECDSA_Sign
*
* Inputs:
* @param SignerPrivKey_ptr [in] - A pointer to a user private key structure.    				
* @param HashMode [in] - The enumerator variable defines hash function to be used.                         
* @param MessageDataIn_ptr [in] - A message data for calculation of hash.   			
* @param MessageSizeInBytes [in] - A size of block of message data in bytes. 
* @param SignatureOut_ptr [out] - A pointer to a buffer for output of signature.                         
* @param SignatureOutSize_ptr [out] - Size of user passed buffer for signature (in)
*                         and size of actual signature (out).
* @param IsEphemerKeyInternal [in] - A parameter defining whether ephemeral 
*                         key internal or external
* @param EphemerPublKeyIn_ptr [in] - A pointer to ephemeral public key.
* @param EphemerPublKeySizeBytes [in] - A size (in bytes) of sender's ephemeral 
*                            public key data.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECDSA_SIGN_INVALID_USER_PRIV_KEY_PTR_ERROR
*   - CE2_ECDSA_SIGN_ILLEGAL_HASH_OP_MODE_ERROR
*   - CE2_ECDSA_SIGN_INVALID_MESSAGE_DATA_IN_PTR_ERROR
*   - CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_PTR_ERROR
*   - CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_SIZE_PTR_ERROR
*   - CE2_ECDSA_SIGN_INVALID_EPHEMERAL_KEY_IN_ERROR
*
* \brief \b 
* Description:
*  Performs all of the ECDSA signing operations simultaneously.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECDSA_Sign 
*     for ECDSA signing operations with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_DX_ECDSA_Sign(
	CE2_ECPKI_UserPrivKey_t      *SignerPrivKey_ptr,       /*in*/
	CE2_ECPKI_HASH_OpMode_t       HashMode,                /*in*/
	DxUint8_t                     *MessageDataIn_ptr,       /*in*/ 
	DxUint32_t                     MessageSizeInBytes,      /*in*/
	DxUint8_t                     *SignatureOut_ptr,        /*out*/ 
	DxUint32_t                    *SignatureOutSize_ptr,     /*in*/
	DxInt8_t                      IsEphemerKeyInternal,    /*in*/
	DxUint8_t                     *EphemerPublKeyIn_ptr,    /*in*/ 
	DxUint32_t                     EphemerPublKeySizeBytes /*in*/); 

/**
****************************************************************
* Function Name: 
*  CE2_DX_ECDSA_Sign
*
* Inputs:
* @param SignerPrivKey_ptr [in] - A pointer to a user private key structure.    				
* @param HashMode [in] - The enumerator variable defines hash function to be used.                         
* @param MessageDataIn_ptr [in] - A message data for calculation of hash.   			
* @param MessageSizeInBytes [in] - A size of block of message data in bytes. 
* @param SignatureOut_ptr [out] - A pointer to a buffer for output of signature.                         
* @param SignatureOutSize_ptr [out] - Size of user passed buffer for signature (in)
*                         and size of actual signature (out).
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECDSA_SIGN_INVALID_USER_PRIV_KEY_PTR_ERROR
*   - CE2_ECDSA_SIGN_ILLEGAL_HASH_OP_MODE_ERROR
*   - CE2_ECDSA_SIGN_INVALID_MESSAGE_DATA_IN_PTR_ERROR
*   - CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_PTR_ERROR
*   - CE2_ECDSA_SIGN_INVALID_SIGNATURE_OUT_SIZE_PTR_ERROR
*
* \brief \b 
* Description:
*  Performs all of the ECDSA signing operations simultaneously.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function CE2_DX_ECDSA_Sign 
*     for ECDSA signing operations with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_ECDSA_Sign(
	CE2_ECPKI_UserPrivKey_t      *SignerPrivKey_ptr,       /*in*/
	CE2_ECPKI_HASH_OpMode_t       HashMode,                /*in*/
	DxUint8_t                     *MessageDataIn_ptr,       /*in*/ 
	DxUint32_t                     MessageSizeInBytes,      /*in*/
	DxUint8_t                     *SignatureOut_ptr,        /*out*/ 
	DxUint32_t                    *SignatureOutSize_ptr     /*in*/); 
/**
****************************************************************
* Function Name: 
*  CE2_ECDSA_Verify
*
* Inputs:
* @param UserPublKey_ptr [in] - A pointer to a user public key structure.
* @param HashMode [in] - The enumerator variable defines the hash function to be used.
* @param MessageDataIn_ptr [in] - Message data for calculating hash.   			
* @param MessageSizeInBytes [in] - Size of block of message data in bytes.       
* @param SignatureIn_ptr [in] - A pointer to a buffer for output of signature. 
* @param SignatureSizeBytes [in] - Size of signature, in bytes
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECDSA_VERIFY_INVALID_SIGNER_PUBL_KEY_PTR_ERROR
*   - CE2_ECDSA_VERIFY_ILLEGAL_HASH_OP_MODE_ERROR
*   - CE2_ECDSA_VERIFY_INVALID_SIGNATURE_IN_PTR_ERROR
*   - CE2_ECDSA_VERIFY_INVALID_MESSAGE_DATA_IN_PTR_ERROR
*
* \brief \b 
* Description:
*  Performs all of the ECDSA verifying operations simultaneously.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECDSA_Verify 
*     for ECDSA verifying operations with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_ECDSA_Verify (
									   	  CE2_ECPKI_UserPublKey_t       *UserPublKey_ptr,        /*in*/
									      CE2_ECPKI_HASH_OpMode_t        HashMode,               /*in*/
										  DxUint8_t                      *SignatureIn_ptr,        /*in*/
										  DxUint32_t                      SignatureSizeBytes,     /*in*/
										  DxUint8_t                      *MessageDataIn_ptr,      /*in*/ 
										  DxUint32_t                      MessageSizeInBytes      /*in*/ );


/**********************************************************************************************************/


#ifdef __cplusplus
}
#endif			

#endif
